package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.AttributesNode

object AttributesNodeSerializer extends AstNodeSerializer[AttributesNode] {

  override protected def doSerialize(node: AttributesNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val attrs = AstToSerializableMapper.serializeSeq(node.attrs)
    val children = Seq(_annotations, attrs)
    NodeSerializableAstNode(SerializableAstNodeKind.ATTRIBUTES_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): AttributesNode = {
    val attrs = AstToSerializableMapper.deserializeSeq(children.head, context)
    AttributesNode(attrs)
  }
}
