package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.nonAst.OpIdSerializer
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.grammar.BinaryOpIdentifier
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode

object BinaryOpNodeSerializer extends AstNodeSerializer[BinaryOpNode] {

  override protected def doSerialize(node: BinaryOpNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val opId = OpIdSerializer.serialize(node.opId)
    val lhs = AstToSerializableMapper.serialize(node.lhs)
    val rhs = AstToSerializableMapper.serialize(node.rhs)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, opId, lhs, rhs, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.BINARY_OP_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): BinaryOpNode = {
    val op = OpIdSerializer.deserialize(children.head, context).asInstanceOf[BinaryOpIdentifier]
    val lhs = AstToSerializableMapper.deserialize(children(1), context)
    val rhs = AstToSerializableMapper.deserialize(children(2), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    BinaryOpNode(op, lhs, rhs, annotations)
  }
}
