package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode

object InputDirectiveSerializer extends AstNodeSerializer[InputDirective] {

  override protected def doSerialize(node: InputDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val dataFormat = DataFormatIdSerializer.serializeMaybe(node.dataFormat)
    val mime = ContentTypeSerializer.serializeMaybe(node.mime)
    val options = DirectiveOptionSerializer.serializeMaybeSeq(node.options)
    val wtype = AstToSerializableMapper.serializeMaybe(node.wtype)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, dataFormat, mime, options, wtype, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.INPUT_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): InputDirective = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, context)
    val dataFormat = DataFormatIdSerializer.deserializeMaybe(children(1), context)
    val mime = ContentTypeSerializer.deserializeMaybe(children(2), context)
    val options = DirectiveOptionSerializer.deserializeMaybeSeq(children(3), context)
    val wtype = AstToSerializableMapper.deserializeMaybe(children(4), context).asInstanceOf[Option[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(5), context)
    InputDirective(identifier, dataFormat, mime, options, wtype, annotations)
  }
}
