package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.{ PatternExpressionNode, PatternExpressionsNode }

object PatternExpressionsNodeSerializer extends AstNodeSerializer[PatternExpressionsNode] {

  override protected def doSerialize(node: PatternExpressionsNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val patterns = AstToSerializableMapper.serializeSeq(node.patterns)
    val children: Seq[SerializableAstNode] = Seq(_annotations, patterns)
    NodeSerializableAstNode(SerializableAstNodeKind.PATTERN_EXPRESSIONS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): PatternExpressionsNode = {
    val patterns = AstToSerializableMapper.deserializeSeq(children.head, context).asInstanceOf[Seq[PatternExpressionNode]]
    PatternExpressionsNode(patterns)
  }
}
