package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.StringInterpolationNode

object StringInterpolationNodeSerializer extends AstNodeSerializer[StringInterpolationNode] {

  override protected def doSerialize(node: StringInterpolationNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elements = AstToSerializableMapper.serializeSeq(node.elements)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elements)
    NodeSerializableAstNode(SerializableAstNodeKind.STRING_INTERPOLATION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): StringInterpolationNode = {
    val elements = AstToSerializableMapper.deserializeSeq(children.head, context)
    StringInterpolationNode(elements)
  }
}
