package org.mule.weave.v2.runtime.core.operator.math

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.runtime.core.exception.MultiplicationExecutionException

class NumberMultiplicationOperator(override val location: WeaveLocation) extends BinaryFunctionValue {

  override val L = NumberType

  override val R = NumberType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val leftNumber = leftValue.evaluate
    val rightNumber = rightValue.evaluate
    NumberValue(doMultiplication(leftNumber, rightNumber)(Some(ctx)), this)
  }

  def doMultiplication(leftNumber: math.Number, rightNumber: math.Number)(implicit maybeCtx: Option[EvaluationContext]): math.Number = {
    try {
      maybeCtx match {
        case Some(ctx) => ctx.serviceManager.mathService().multiply(leftNumber, rightNumber)
        case None      => leftNumber * rightNumber
      }
    } catch {
      case ae: ArithmeticException => {
        throw new MultiplicationExecutionException(leftNumber.toString, rightNumber.toString, ae.getMessage, location)
      }
    }
  }

}
