package org.mule.weave.v2.compilation.mapper

import org.mule.weave.v2.compilation.{ SerializableAstNode, SerializableAstNodeKind }
import org.mule.weave.v2.compilation.exception.{ DeserializationException, SerializationException }
import org.mule.weave.v2.compilation.mapper.ast._
import org.mule.weave.v2.parser.ast.{ AstNode, UndefinedExpressionNode }
import org.mule.weave.v2.parser.ast.annotation.{ AnnotationArgumentNode, AnnotationArgumentsNode, AnnotationNode }
import org.mule.weave.v2.parser.ast.conditional.{ DefaultNode, IfNode, UnlessNode }
import org.mule.weave.v2.parser.ast.functions._
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives._
import org.mule.weave.v2.parser.ast.logical.{ AndNode, OrNode }
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.operators.{ BinaryOpNode, UnaryOpNode }
import org.mule.weave.v2.parser.ast.patterns._
import org.mule.weave.v2.parser.ast.selectors.{ ExistsSelectorNode, NullSafeNode, NullUnSafeNode }
import org.mule.weave.v2.parser.ast.structure._
import org.mule.weave.v2.parser.ast.structure.schema.{ SchemaNode, SchemaPropertyNode }
import org.mule.weave.v2.parser.ast.types._
import org.mule.weave.v2.parser.ast.updates._
import org.mule.weave.v2.parser.ast.variables.{ NameIdentifier, VariableReferenceNode }

object AstToSerializableMapper extends DWSerializer[AstNode] {

  override def serialize(node: AstNode): SerializableAstNode = {
    node match {
      case n: DocumentNode                      => DocumentNodeSerializer.serialize(n)
      //VALUE WRAPPERS
      case n: BooleanNode                       => BooleanNodeSerializer.serialize(n)
      case n: DateTimeNode                      => DateTimeNodeSerializer.serialize(n)
      case n: LocalDateNode                     => LocalDateNodeSerializer.serialize(n)
      case n: LocalDateTimeNode                 => LocalDateTimeNodeSerializer.serialize(n)
      case n: LocalTimeNode                     => LocalTimeNodeSerializer.serialize(n)
      case n: NullNode                          => NullNodeSerializer.serialize(n)
      case n: NumberNode                        => NumberNodeSerializer.serialize(n)
      case n: PeriodNode                        => PeriodNodeSerializer.serialize(n)
      case n: RegexNode                         => RegexNodeSerializer.serialize(n)
      case n: StringNode                        => StringNodeSerializer.serialize(n)
      case n: TimeNode                          => TimeNodeSerializer.serialize(n)
      case n: TimeZoneNode                      => TimeZoneNodeSerializer.serialize(n)
      case n: UriNode                           => UriNodeSerializer.serialize(n)
      case n: ArrayNode                         => ArrayNodeSerializer.serialize(n)
      case n: ObjectNode                        => ObjectNodeSerializer.serialize(n)
      case n: KeyValuePairNode                  => KeyValuePairNodeSerializer.serialize(n)
      case n: KeyNode                           => KeyNodeSerializer.serialize(n)
      case n: NameNode                          => NameNodeSerializer.serialize(n)
      //OPERATORS
      case n: UnaryOpNode                       => UnaryOpNodeSerializer.serialize(n)
      case n: BinaryOpNode                      => BinaryOpNodeSerializer.serialize(n)
      //DIRECTIVES
      case n: AnnotationDirectiveNode           => AnnotationDirectiveNodeSerializer.serialize(n)
      case n: FunctionDirectiveNode             => FunctionDirectiveNodeSerializer.serialize(n)
      case n: ImportDirective                   => ImportDirectiveSerializer.serialize(n)
      case n: InputDirective                    => InputDirectiveSerializer.serialize(n)
      case n: OutputDirective                   => OutputDirectiveSerializer.serialize(n)
      case n: NamespaceDirective                => NamespaceDirectiveSerializer.serialize(n)
      case n: TypeDirective                     => TypeDirectiveSerializer.serialize(n)
      case n: VarDirective                      => VarDirectiveSerializer.serialize(n)
      case n: VersionDirective                  => VersionDirectiveSerializer.serialize(n)
      case n: VersionMajor                      => VersionMajorSerializer.serialize(n)
      case n: VersionMinor                      => VersionMinorSerializer.serialize(n)
      case n: AnnotationParametersNode          => AnnotationParametersNodeSerializer.serialize(n)
      case n: AnnotationParameterNode           => AnnotationParameterNodeSerializer.serialize(n)
      case n: DirectiveOption                   => DirectiveOptionSerializer.serialize(n)
      case n: DirectiveOptionName               => DirectiveOptionNameSerializer.serialize(n)
      case n: ImportedElements                  => ImportedElementsSerializer.serialize(n)
      case n: ImportedElement                   => ImportedElementSerializer.serialize(n)
      //DEFAULT
      case n: HeaderNode                        => HeaderNodeSerializer.serialize(n)
      case n: AndNode                           => AndNodeSerializer.serialize(n)
      case n: OrNode                            => OrNodeSerializer.serialize(n)
      case n: ModuleNode                        => ModuleNodeSerializer.serialize(n)
      case n: DynamicKeyNode                    => DynamicKeyNodeSerializer.serialize(n)
      case n: DoBlockNode                       => DoBlockNodeSerializer.serialize(n)
      case n: NullSafeNode                      => NullSafeNodeSerializer.serialize(n)
      case n: NullUnSafeNode                    => NullUnSafeNodeSerializer.serialize(n)
      case n: ConditionalNode                   => ConditionalNodeSerializer.serialize(n)
      case n: IfNode                            => IfNodeSerializer.serialize(n)
      case n: UnlessNode                        => UnlessNodeSerializer.serialize(n)
      case n: FunctionNode                      => FunctionNodeSerializer.serialize(n)
      case n: FunctionParameters                => FunctionParametersSerializer.serialize(n)
      case n: FunctionParameter                 => FunctionParameterSerializer.serialize(n)
      case n: TypeParametersListNode            => TypeParametersListNodeSerializer.serialize(n)
      case n: SchemaNode                        => SchemaNodeSerializer.serialize(n)
      case n: SchemaPropertyNode                => SchemaPropertyNodeSerializer.serialize(n)
      case n: VariableReferenceNode             => VariableReferenceNodeSerializer.serialize(n)
      case n: NameIdentifier                    => NameIdentifierSerializer.serialize(n)
      case n: FunctionCallNode                  => FunctionCallNodeSerializer.serialize(n)
      case n: FunctionCallParametersNode        => FunctionCallParametersNodeSerializer.serialize(n)
      case n: TypeParametersApplicationListNode => TypeParametersApplicationListNodeSerializer.serialize(n)
      case n: ContentType                       => ContentTypeSerializer.serialize(n)
      case n: DataFormatId                      => DataFormatIdSerializer.serialize(n)
      case n: NamespaceNode                     => NamespaceNodeSerializer.serialize(n)
      case n: HeadTailArrayNode                 => HeadTailArrayNodeSerializer.serialize(n)
      case n: HeadTailObjectNode                => HeadTailObjectNodeSerializer.serialize(n)
      case n: StringInterpolationNode           => StringInterpolationNodeSerializer.serialize(n)
      case n: AnnotationNode                    => AnnotationNodeSerializer.serialize(n)
      case n: AnnotationArgumentsNode           => AnnotationArgumentsNodeSerializer.serialize(n)
      case n: AnnotationArgumentNode            => AnnotationArgumentNodeSerializer.serialize(n)
      case n: AttributesNode                    => AttributesNodeSerializer.serialize(n)
      case n: NameValuePairNode                 => NameValuePairNodeSerializer.serialize(n)
      case n: PatternMatcherNode                => PatternMatcherNodeSerializer.serialize(n)
      case n: PatternExpressionsNode            => PatternExpressionsNodeSerializer.serialize(n)
      case n: DeconstructArrayPatternNode       => DeconstructArrayPatternNodeSerializer.serialize(n)
      case n: DeconstructObjectPatternNode      => DeconstructObjectPatternNodeSerializer.serialize(n)
      case n: DefaultPatternNode                => DefaultPatternNodeSerializer.serialize(n)
      case n: EmptyArrayPatternNode             => EmptyArrayPatternNodeSerializer.serialize(n)
      case n: EmptyObjectPatternNode            => EmptyObjectPatternNodeSerializer.serialize(n)
      case n: ExpressionPatternNode             => ExpressionPatternNodeSerializer.serialize(n)
      case n: LiteralPatternNode                => LiteralPatternNodeSerializer.serialize(n)
      case n: RegexPatternNode                  => RegexPatternNodeSerializer.serialize(n)
      case n: TypePatternNode                   => TypePatternNodeSerializer.serialize(n)
      case n: UsingNode                         => UsingNodeSerializer.serialize(n)
      case n: UsingVariableAssignments          => UsingVariableAssignmentsSerializer.serialize(n)
      case n: UsingVariableAssignment           => UsingVariableAssignmentSerializer.serialize(n)
      case n: DefaultNode                       => DefaultNodeSerializer.serialize(n)
      case n: UpdateNode                        => UpdateNodeSerializer.serialize(n)
      case n: UpdateExpressionsNode             => UpdateExpressionsNodeSerializer.serialize(n)
      case n: UpdateExpressionNode              => UpdateExpressionNodeSerializer.serialize(n)
      case n: ArrayIndexUpdateSelectorNode      => ArrayIndexUpdateSelectorNodeSerializer.serialize(n)
      case n: AttributeNameUpdateSelectorNode   => AttributeNameUpdateSelectorNodeSerializer.serialize(n)
      case n: FieldNameUpdateSelectorNode       => FieldNameUpdateSelectorNodeSerializer.serialize(n)
      case n: MultiFieldNameUpdateSelectorNode  => MultiFieldNameUpdateSelectorNodeSerializer.serialize(n)
      case n: ExistsSelectorNode                => ExistsSelectorNodeSerializer.serialize(n)
      case n: DynamicNameNode                   => DynamicNameNodeSerializer.serialize(n)
      case n: OverloadedFunctionNode            => OverloadedFunctionNodeSerializer.serialize(n)
      case n: UndefinedExpressionNode           => UndefinedExpressionNodeSerializer.serialize(n)
      //TYPES
      case n: DynamicReturnTypeNode             => DynamicReturnTypeNodeSerializer.serialize(n)
      case n: FunctionParameterTypeNode         => FunctionParameterTypeNodeSerializer.serialize(n)
      case n: KeyValueTypeNode                  => KeyValueTypeNodeSerializer.serialize(n)
      case n: NameValueTypeNode                 => NameValueTypeNodeSerializer.serialize(n)
      case n: NativeTypeNode                    => NativeTypeNodeSerializer.serialize(n)
      case n: TypeParameterNode                 => TypeParameterNodeSerializer.serialize(n)
      case n: FunctionTypeNode                  => FunctionTypeNodeSerializer.serialize(n)
      case n: IntersectionTypeNode              => IntersectionTypeNodeSerializer.serialize(n)
      case n: KeyTypeNode                       => KeyTypeNodeSerializer.serialize(n)
      case n: LiteralTypeNode                   => LiteralTypeNodeSerializer.serialize(n)
      case n: NameTypeNode                      => NameTypeNodeSerializer.serialize(n)
      case n: ObjectTypeNode                    => ObjectTypeNodeSerializer.serialize(n)
      case n: TypeReferenceNode                 => TypeReferenceNodeSerializer.serialize(n)
      case n: TypeSelectorNode                  => TypeSelectorNodeSerializer.serialize(n)
      case n: UnionTypeNode                     => UnionTypeNodeSerializer.serialize(n)
      case _                                    => throw SerializationException(s"Can't serialize node of class: ${node.getClass}")
    }
  }

  override def deserialize(node: SerializableAstNode, context: SerializerContext): AstNode = {
    node.kind() match {
      case SerializableAstNodeKind.DOCUMENT_NODE => DocumentNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.HEADER_NODE => HeaderNodeSerializer.deserialize(node, context)
      //DIRECTIVES
      case SerializableAstNodeKind.ANNOTATION_DIRECTIVE_NODE => AnnotationDirectiveNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FUNCTION_DIRECTIVE_NODE => FunctionDirectiveNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.IMPORT_DIRECTIVE_NODE => ImportDirectiveSerializer.deserialize(node, context)
      case SerializableAstNodeKind.INPUT_DIRECTIVE_NODE => InputDirectiveSerializer.deserialize(node, context)
      case SerializableAstNodeKind.OUTPUT_DIRECTIVE_NODE => OutputDirectiveSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NAMESPACE_DIRECTIVE_NODE => NamespaceDirectiveSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TYPE_DIRECTIVE_NODE => TypeDirectiveSerializer.deserialize(node, context)
      case SerializableAstNodeKind.VAR_DIRECTIVE_NODE => VarDirectiveSerializer.deserialize(node, context)
      case SerializableAstNodeKind.VERSION_MAJOR_NODE => VersionMajorSerializer.deserialize(node, context)
      case SerializableAstNodeKind.VERSION_MINOR_NODE => VersionMinorSerializer.deserialize(node, context)
      case SerializableAstNodeKind.VERSION_DIRECTIVE_NODE => VersionDirectiveSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DIRECTIVE_OPTION_NODE => DirectiveOptionSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DIRECTIVE_OPTION_NAME_NODE => DirectiveOptionNameSerializer.deserialize(node, context)
      case SerializableAstNodeKind.IMPORTED_ELEMENTS_NODE => ImportedElementsSerializer.deserialize(node, context)
      case SerializableAstNodeKind.IMPORTED_ELEMENT_NODE => ImportedElementSerializer.deserialize(node, context)
      //OPERATORS
      case SerializableAstNodeKind.UNARY_OP_NODE => UnaryOpNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.BINARY_OP_NODE => BinaryOpNodeSerializer.deserialize(node, context)
      //VALUES
      case SerializableAstNodeKind.BOOL_NODE => BooleanNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DATE_TIME_NODE => DateTimeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.LOCAL_DATE_NODE => LocalDateNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.LOCAL_DATE_TIME_NODE => LocalDateTimeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.LOCAL_TIME_NODE => LocalTimeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NULL_NODE => NullNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NUMBER_NODE => NumberNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.PERIOD_NODE => PeriodNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.REGEX_NODE => RegexNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.STRING_NODE => StringNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TIME_NODE => TimeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TIME_ZONE_NODE => TimeZoneNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.URI_NODE => UriNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ARRAY_LITERAL_NODE => ArrayNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.OBJECT_LITERAL_NODE => ObjectNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.KEY_VALUE_PAIR_NODE => KeyValuePairNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.KEY_NODE => KeyNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NAME_NODE => NameNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ANNOTATION_PARAMETERS_NODE => AnnotationParametersNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ANNOTATION_PARAMETER_NODE => AnnotationParameterNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.AND_NODE => AndNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.OR_NODE => OrNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.MODULE_NODE => ModuleNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DYNAMIC_KEY_NODE => DynamicKeyNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DO_BLOCK_NODE => DoBlockNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NULL_SAFE_NODE => NullSafeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NULL_UNSAFE_NODE => NullUnSafeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.CONDITIONAL_NODE => ConditionalNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.IF_NODE => IfNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.UNLESS_NODE => UnlessNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FUNCTION_NODE => FunctionNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FUNCTION_PARAMETERS_NODE => FunctionParametersSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FUNCTION_PARAMETER_NODE => FunctionParameterSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TYPE_PARAMETERS_LIST_NODE => TypeParametersListNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.SCHEMA_NODE => SchemaNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.SCHEMA_PROPERTY_NODE => SchemaPropertyNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.VARIABLE_REFERENCE_NODE => VariableReferenceNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NAME_IDENTIFIER_NODE => NameIdentifierSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FUNCTION_CALL_NODE => FunctionCallNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FUNCTION_CALL_PARAMETERS_NODE => FunctionCallParametersNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TYPE_PARAMETERS_APPLICATION_LIST_NODE => TypeParametersApplicationListNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.CONTENT_TYPE_NODE => ContentTypeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DATA_FORMAT_ID_NODE => DataFormatIdSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NAMESPACE_NODE => NamespaceNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.HEAD_TAIL_ARRAY_NODE => HeadTailArrayNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.HEAD_TAIL_OBJECT_NODE => HeadTailObjectNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.STRING_INTERPOLATION_NODE => StringInterpolationNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ANNOTATION_NODE => AnnotationNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ANNOTATION_ARGUMENTS_NODE => AnnotationArgumentsNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ANNOTATION_ARGUMENT_NODE => AnnotationArgumentNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ATTRIBUTES_NODE => AttributesNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NAME_VALUE_PAIR_NODE => NameValuePairNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.PATTERN_MATCHER_NODE => PatternMatcherNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.PATTERN_EXPRESSIONS_NODE => PatternExpressionsNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DECONSTRUCT_ARRAY_PATTERN_NODE => DeconstructArrayPatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DECONSTRUCT_OBJECT_PATTERN_NODE => DeconstructObjectPatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DEFAULT_PATTERN_NODE => DefaultPatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.EMPTY_ARRAY_PATTERN_NODE => EmptyArrayPatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.EMPTY_OBJECT_PATTERN_NODE => EmptyObjectPatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.EXPRESSION_PATTERN_NODE => ExpressionPatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.LITERAL_PATTERN_NODE => LiteralPatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.REGEX_PATTERN_NODE => RegexPatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TYPE_PATTERN_NODE => TypePatternNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.USING_NODE => UsingNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.USING_VARIABLE_ASSIGNMENTS_NODE => UsingVariableAssignmentsSerializer.deserialize(node, context)
      case SerializableAstNodeKind.USING_VARIABLE_ASSIGNMENT_NODE => UsingVariableAssignmentSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DEFAULT_NODE => DefaultNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.UPDATE_NODE => UpdateNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.UPDATE_EXPRESSIONS_NODE => UpdateExpressionsNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.UPDATE_EXPRESSION_NODE => UpdateExpressionNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ARRAY_INDEX_UPDATE_SELECTOR_NODE => ArrayIndexUpdateSelectorNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.ATTRIBUTE_NAME_UPDATE_SELECTOR_NODE => AttributeNameUpdateSelectorNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FIELD_NAME_UPDATE_SELECTOR_NODE => FieldNameUpdateSelectorNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.MULTI_FIELD_NAME_UPDATE_SELECTOR_NODE => MultiFieldNameUpdateSelectorNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.EXISTS_SELECTOR_NODE => ExistsSelectorNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.DYNAMIC_NAME_NODE => DynamicNameNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.OVERLOADED_FUNCTION_NODE => OverloadedFunctionNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.UNDEFINED_EXPRESSION_NODE => UndefinedExpressionNodeSerializer.deserialize(node, context)
      //TYPES
      case SerializableAstNodeKind.DYNAMIC_RETURN_TYPE_NODE => DynamicReturnTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FUNCTION_PARAMETER_TYPE_NODE => FunctionParameterTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.KEY_VALUE_TYPE_NODE => KeyValueTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NAME_VALUE_TYPE_NODE => NameValueTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NATIVE_TYPE_NODE => NativeTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TYPE_PARAMETER_NODE => TypeParameterNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.FUNCTION_TYPE_NODE => FunctionTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.INTERSECTION_TYPE_NODE => IntersectionTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.KEY_TYPE_NODE => KeyTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.LITERAL_TYPE_NODE => LiteralTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.NAME_TYPE_NODE => NameTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.OBJECT_TYPE_NODE => ObjectTypeNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TYPE_REFERENCE_NODE => TypeReferenceNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.TYPE_SELECTOR_NODE => TypeSelectorNodeSerializer.deserialize(node, context)
      case SerializableAstNodeKind.UNION_TYPE_NODE => UnionTypeNodeSerializer.deserialize(node, context)
      case _ => throw DeserializationException(s"Can't deserialize node of kind: ${node.kind()}")
    }
  }
}

