package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.DataFormatId

object DataFormatIdSerializer extends AstNodeSerializer[DataFormatId] {

  override protected def doSerialize(node: DataFormatId, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val id = serializeString(node.id)
    val children: Seq[SerializableAstNode] = Seq(_annotations, id)
    NodeSerializableAstNode(SerializableAstNodeKind.DATA_FORMAT_ID_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DataFormatId = {
    val id = deserializeString(children.head)
    DataFormatId(id)
  }
}
