package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.DynamicKeyNode

object DynamicKeyNodeSerializer extends AstNodeSerializer[DynamicKeyNode] {

  override protected def doSerialize(node: DynamicKeyNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val keyName = AstToSerializableMapper.serialize(node.keyName)
    val attr = AstToSerializableMapper.serializeMaybe(node.attr)
    val children: Seq[SerializableAstNode] = Seq(_annotations, keyName, attr)
    NodeSerializableAstNode(SerializableAstNodeKind.DYNAMIC_KEY_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DynamicKeyNode = {
    val keyName = AstToSerializableMapper.deserialize(children.head, context)
    val attr = AstToSerializableMapper.deserializeMaybe(children(1), context)
    DynamicKeyNode(keyName, attr)
  }
}
