package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode

object KeyValuePairNodeSerializer extends AstNodeSerializer[KeyValuePairNode] {

  override protected def doSerialize(node: KeyValuePairNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val key = AstToSerializableMapper.serialize(node.key)
    val value = AstToSerializableMapper.serialize(node.value)
    val cond = AstToSerializableMapper.serializeMaybe(node.cond)
    val children: Seq[SerializableAstNode] = Seq(_annotations, key, value, cond)
    NodeSerializableAstNode(SerializableAstNodeKind.KEY_VALUE_PAIR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): KeyValuePairNode = {
    val key = AstToSerializableMapper.deserialize(children.head, context)
    val value = AstToSerializableMapper.deserialize(children(1), context)
    val cond = AstToSerializableMapper.deserializeMaybe(children(2), context)
    KeyValuePairNode(key, value, cond)
  }
}
