package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.structure.LocalDateNode

object LocalDateNodeSerializer extends AstNodeSerializer[LocalDateNode] {

  override protected def doSerialize(node: LocalDateNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val value = serializeString(node.literalValue)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, value, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.LOCAL_DATE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): LocalDateNode = {
    val value = deserializeString(children.head)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), context)
    LocalDateNode(value, annotations)
  }
}
