package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.structure.NullNode

object NullNodeSerializer extends AstNodeSerializer[NullNode] {

  override protected def doSerialize(node: NullNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.NULL_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NullNode = {
    val annotations = AnnotationNodeSerializer.deserializeSeq(children.head, context)
    NullNode(annotations)
  }
}
