package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ TypeSelectorNode, WeaveTypeNode }

object TypeSelectorNodeSerializer extends AstNodeSerializer[TypeSelectorNode] {

  override protected def doSerialize(node: TypeSelectorNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selector = NameNodeSerializer.serialize(node.selector)
    val wtype = AstToSerializableMapper.serialize(node.weaveTypeNode)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selector, wtype, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_SELECTOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): TypeSelectorNode = {
    val selector = NameNodeSerializer.deserialize(children.head, context)
    val wtype = AstToSerializableMapper.deserialize(children(1), context).asInstanceOf[WeaveTypeNode]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), context)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(3), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(4), context)
    TypeSelectorNode(selector, wtype, maybeSchema, maybeTypeSchema, annotations)
  }
}
