package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.UndefinedExpressionNode

object UndefinedExpressionNodeSerializer extends AstNodeSerializer[UndefinedExpressionNode] {

  override protected def doSerialize(node: UndefinedExpressionNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    NodeSerializableAstNode(SerializableAstNodeKind.UNDEFINED_EXPRESSION_NODE, location, Seq(_annotations))
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UndefinedExpressionNode = UndefinedExpressionNode()
}
