package org.mule.weave.v2.interpreted

import org.mule.weave.v2.core.exception.InvalidOptionException
import org.mule.weave.v2.core.exception.InvalidOptionTypeException
import org.mule.weave.v2.interpreted.node.structure.header.directives.DirectiveOption
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.ConfigurableReaderWriter
import org.mule.weave.v2.module.option.ModuleOption
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.UnknownLocation

object ConfigurationHelper {

  def configure(configAware: ConfigurableReaderWriter, directiveOption: DirectiveOption)(implicit ctx: EvaluationContext): Unit = {
    val executionContext: ExecutionContext = ExecutionContext(evaluationContext = ctx)
    val optionValue: Value[_] = directiveOption.value.execute(executionContext)
    val location: Location = directiveOption.location()
    val optionName: String = directiveOption.name.execute(executionContext).evaluate
    val validOptions = configAware.settings.settingsOptions()
    if (!validOptions.containsOption(optionName)) {
      throw new InvalidOptionException(location, optionName, Some(validOptions.optionNames()))
    } else {

      val moduleOption: ModuleOption = validOptions.getOption(optionName).get
      val expectedType: Type = moduleOption.dataType
      if (expectedType.accepts(optionValue)) {
        configAware.setOption(location, moduleOption.name, optionValue.evaluate)
      } else {
        throw new InvalidOptionTypeException(optionValue.location(), optionName, optionValue.valueType, expectedType)
      }
    }
  }

  def configure[T <: ConfigurableReaderWriter](configAware: T, options: Map[String, Any]): T = {
    implicit val context: ExecutionContext = EmptyExecutionContext()
    options.foreach((option) => {
      val optionName = option._1
      val optionValue = option._2
      val location = UnknownLocation
      val validOptions = configAware.settings.settingsOptions()
      if (!validOptions.containsOption(optionName)) {
        throw new InvalidOptionException(location, optionName, Some(validOptions.optionNames()))
      } else {

        val moduleOption: ModuleOption = validOptions.getOption(optionName).get
        configAware.setOption(location, moduleOption.name, optionValue)
      }
    })
    configAware
  }

}
