package org.mule.weave.v2.interpreted.node.structure.function

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.values.FunctionParameter
import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.parser.location.WeaveLocation

import scala.annotation.switch

class StaticFunctionNode(params: Array[FunctionParameterNode], body: ValueNode[_], returnTypeNode: Option[ValueNode[Type]], requiresMaterializedArguments: Boolean, val name: Option[String] = None) extends ValueNode[(Array[Value[_]]) => Value[_]] with Product2[Seq[FunctionParameterNode], ValueNode[_]] {

  private var value: FunctionValue = _

  val minParams: Int = params.count((param) => param.defaultValue.isEmpty)

  val maxParams: Int = params.length

  //This is for injected functions
  override def location(): WeaveLocation = _location.getOrElse(body.location())

  override def _1: Seq[FunctionParameterNode] = params

  override def _2: ValueNode[_] = body

  override protected def doExecute(implicit ctx: ExecutionContext): FunctionValue = {
    if (value == null) {
      this.synchronized {
        if (value == null) {
          val frame = ctx.executionStack().activeFrame()
          value = (params.length: @switch) match {
            case 0 => new EmptyFunctionExecutionContextAwareFunction(frame, body, returnTypeNode, this, name)
            case 1 => {
              val parameters = calculateFunctionParams(ctx)
              new UnaryFunctionExecutionContextAwareFunction(parameters.head, params.head, frame, body, returnTypeNode, this, name, minParams, requiresMaterializedArguments)
            }
            case 2 => {
              val parameters = calculateFunctionParams(ctx)
              new BinaryFunctionExecutionContextAwareFunction(parameters(0), parameters(1), params(0), params(1), frame, body, returnTypeNode, this, name, minParams, requiresMaterializedArguments)
            }
            case 3 => {
              val parameters = calculateFunctionParams(ctx)
              new TernaryFunctionExecutionContextAwareFunction(parameters(0), parameters(1), parameters(2), params(0), params(1), params(2), frame, body, returnTypeNode, this, name, minParams, requiresMaterializedArguments)
            }
            case 4 => {
              val parameters = calculateFunctionParams(ctx)
              new QuaternaryFunctionExecutionContextAwareFunction(
                parameters(0),
                parameters(1),
                parameters(2),
                parameters(3),
                params(0),
                params(1),
                params(2),
                params(3),
                frame,
                body,
                returnTypeNode,
                this,
                name,
                minParams,
                requiresMaterializedArguments)
            }
            case _ => DefaultExecutionContextAwareFunction(calculateFunctionParams(ctx), params, body, returnTypeNode, name, frame, this, minParams, maxParams, requiresMaterializedArguments)
          }
        }
      }
    }
    value
  }

  private def calculateFunctionParams(ctx: ExecutionContext): Array[FunctionParameter] = {
    ExecutionContextAwareFunctionValue.calculateParams(params, ctx)
  }
}
