package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.core.util.ObjectValueUtils.selectInt
import org.mule.weave.v2.core.util.ObjectValueUtils.selectString
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.KeyValuePair
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.types.KeyType
import org.mule.weave.v2.model.types.KeyValuePairType
import org.mule.weave.v2.model.types.NameType
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.types.UnionType
import org.mule.weave.v2.model.values.KeyValue
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.ValueProvider
import org.mule.weave.v2.parser.location.LocationCapable

import java.math.MathContext
import java.math.RoundingMode

trait BaseBigDecimalFunctionValue {
  private val PRECISION = "precision"
  private val ROUNDING_MODE = "roundingMode"

  private val roundingModeType = UnionType(
    Seq(
      new StringType(Some("UP")),
      new StringType(Some("DOWN")),
      new StringType(Some("CEILING")),
      new StringType(Some("FLOOR")),
      new StringType(Some("HALF_UP")),
      new StringType(Some("HALF_DOWN")),
      new StringType(Some("HALF_EVEN")),
      new StringType(Some("UNNECESSARY"))))

  protected final val configType: ObjectType = ObjectType(
    Seq(
      new KeyValuePairType(new KeyType(Some(NameType(Some("precision"), None)), Seq.empty), NumberType, true),
      new KeyValuePairType(new KeyType(Some(NameType(Some("roundingMode"), None)), Seq.empty), roundingModeType, true)))

  protected final val contextDefaultValue = (lc: LocationCapable) =>
    Some(ValueProvider(ObjectValue(
      Seq(
        KeyValuePair(KeyValue("precision"), NumberValue(34)),
        KeyValuePair(KeyValue("roundingMode"), StringValue("HALF_EVEN"))),
      lc)))

  protected def toMathContext(config: ObjectSeq)(implicit ctx: EvaluationContext): MathContext = {
    val precision = selectInt(config, PRECISION).getOrElse(34)
    val roundingMode = selectString(config, ROUNDING_MODE).map(RoundingMode.valueOf).getOrElse(RoundingMode.HALF_EVEN)

    new MathContext(precision, roundingMode)
  }
}
