package org.mule.weave.v2.runtime.core.operator.conversion

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.SchemaType
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.wrappers.AsValue
import org.mule.weave.v2.parser.location.DefaultLocationCapable
import org.mule.weave.v2.parser.location.WeaveLocation

class MetadataAdditionFunctionValue(override val location: WeaveLocation) extends BinaryFunctionValue {

  override val L = AnyType

  override val R = SchemaType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val schema = rightValue.evaluate
    val leftValueSchema = leftValue.schema
    val value = AsValue(leftValue, Some(leftValueSchema.map(lvs => Schema(schema, lvs)).getOrElse(schema)), DefaultLocationCapable(location))
    value
  }

}