package org.mule.weave.v2.runtime.core.operator.selectors

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.core.exception.InvalidSelectionException
import org.mule.weave.v2.core.exception.KeyNotFoundException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.NameType
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class SchemaValueSelectorOperator(override val location: WeaveLocation) extends BinaryFunctionValue {
  val delegate = ObjectNameValueSelectorOperator(location)

  override val L = AnyType

  override val R = NameType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    leftValue.schema match {
      case Some(schema) =>
        schema.valueOf(rightValue.evaluate.name) match {
          case Some(v) => v
          case _       => throw InvalidSelectionException(new KeyNotFoundException(this, rightValue.evaluate))
        }
      case _ => NullValue
    }
  }
}

