package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.AnnotationParametersNode

object AnnotationParametersNodeSerializer extends AstNodeSerializer[AnnotationParametersNode] {

  override protected def doSerialize(node: AnnotationParametersNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val paramList = AnnotationParameterNodeSerializer.serializeSeq(node.paramList)
    val children: Seq[SerializableAstNode] = Seq(_annotations, paramList)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_PARAMETERS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): AnnotationParametersNode = {
    val paramList = AnnotationParameterNodeSerializer.deserializeSeq(children.head, context)
    AnnotationParametersNode(paramList)
  }
}
