package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.core.functions.WriteFunctionValue
import org.mule.weave.v2.model.service.SecurityManagerCheckFunctionValue
import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.NativeFunctionUtils.putInto
import org.mule.weave.v2.runtime.core.functions.collections.ArrayAppendArrayFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayContainsFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayDistinctFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayFilterFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayFindFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayFlattenFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayGroupByFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayMapFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayOrderByFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayReduceFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArrayRemoveFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ArraySizeOfFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.BinaryAppendBinaryFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.BinarySizeOfFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.EmptyArrayFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.EmptyObjectFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.EmptyStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.LocalDateAppendLocalTimeFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.LocalDateAppendTimeFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.LocalDateAppendTimeZoneFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.LocalDateTimeAppendTimeZoneFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.LocalTimeAppendLocalDateFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.LocalTimeAppendTimeZoneFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.MapObjectObjectFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ObjectAppendObjectFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ObjectDistinctFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ObjectFilterFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ObjectGroupByFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ObjectOrderByFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ObjectRemoveFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ObjectSizeOfFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.PluckObjectFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.StringAppendStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.StringFindRegexFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.StringFindStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.StringReduceFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.StringRegexContainsFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.StringSizeOfFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.StringStringContainsFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.TimeAppendLocalDateFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.TimeZoneAppendLocalDateFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.TimeZoneAppendLocalDateTimeFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.TimeZoneValueAppendLocalTimeFunctionValue
import org.mule.weave.v2.runtime.core.functions.collections.ToRangeFunctionValue
import org.mule.weave.v2.runtime.core.functions.crypto.HMACFunctionValue
import org.mule.weave.v2.runtime.core.functions.crypto.HashFunctionValue
import org.mule.weave.v2.runtime.core.functions.date.LeapDateTimeFunctionValue
import org.mule.weave.v2.runtime.core.functions.date.LeapLocalDateFunctionValue
import org.mule.weave.v2.runtime.core.functions.date.LeapLocalDateTimeFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.ACosFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.ASinFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.ATanFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.AbsNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.BigDecimalAdditionFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.BigDecimalDivisionFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.BigDecimalMultiplicationFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.BigDecimalPowerFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.BigDecimalRoundFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.BigDecimalSqrtFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.BigDecimalSubtractionFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.CeilNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.CosFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.DecimalNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.FloorNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.IntegerNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.Log10FunctionValue
import org.mule.weave.v2.runtime.core.functions.math.LognFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.ModuleNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.PowNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.RoundNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.SinFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.SqrtNumberFunctionValue
import org.mule.weave.v2.runtime.core.functions.math.TanFunctionValue
import org.mule.weave.v2.runtime.core.functions.mime.FromMimeTypeStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.mime.IsHandledByFunctionValue
import org.mule.weave.v2.runtime.core.functions.mime.ToMimeTypeStringFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.DataWeaveVersionFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.EnvFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.EvaluateCompatibilityFlagFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.LocationFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.SystemPropFunctionValue
import org.mule.weave.v2.runtime.core.functions.runtime.TryFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.CharCodeFunctionValue
import org.mule.weave.v2.runtime.core.functions.stringops.FromCharCodeFunctionValue
import org.mule.weave.v2.runtime.core.functions.types.TypeOfAnyFunctionValue

import scala.collection.mutable

/**
  * Registers all the functions for the dw::Core module
  */
object CoreNativeFunctions {

  def registerFunction(catalog: mutable.Map[String, FunctionValue]): Unit = {
    {
      putInto(ArrayAppendArrayFunctionValue, catalog)
      putInto(StringAppendStringFunctionValue, catalog)
      putInto(BinaryAppendBinaryFunctionValue, catalog)
      putInto(LocalDateAppendLocalTimeFunctionValue, catalog)
      putInto(LocalTimeAppendLocalDateFunctionValue, catalog)
      putInto(LocalDateAppendTimeFunctionValue, catalog)
      putInto(TimeAppendLocalDateFunctionValue, catalog)
      putInto(LocalDateAppendTimeZoneFunctionValue, catalog)
      putInto(TimeZoneAppendLocalDateFunctionValue, catalog)
      putInto(LocalDateTimeAppendTimeZoneFunctionValue, catalog)
      putInto(TimeZoneAppendLocalDateTimeFunctionValue, catalog)
      putInto(LocalTimeAppendTimeZoneFunctionValue, catalog)
      putInto(TimeZoneValueAppendLocalTimeFunctionValue, catalog)
      putInto(ObjectAppendObjectFunctionValue, catalog)
    }

    {
      putInto(ArrayContainsFunctionValue, catalog)
      putInto(StringStringContainsFunctionValue, catalog)
      putInto(StringRegexContainsFunctionValue, catalog)
    }
    {
      putInto(ArrayDistinctFunctionValue, catalog)
      putInto(ObjectDistinctFunctionValue, catalog)
    }
    {
      putInto(ArrayFilterFunctionValue, catalog)
      putInto(ObjectFilterFunctionValue, catalog)
    }

    {
      putInto(ArrayFindFunctionValue, catalog)
      putInto(StringFindRegexFunctionValue, catalog)
      putInto(StringFindStringFunctionValue, catalog)
    }
    {
      putInto(ArrayFlattenFunctionValue, catalog)
    }
    {
      putInto(ArrayGroupByFunctionValue, catalog)
      putInto(ObjectGroupByFunctionValue, catalog)
    }
    {
      putInto(ArrayMapFunctionValue, catalog)
    }
    {
      putInto(MapObjectObjectFunctionValue, catalog)
    }
    {
      putInto(ArrayOrderByFunctionValue, catalog)
      putInto(ObjectOrderByFunctionValue, catalog)
    }
    {
      putInto(PluckObjectFunctionValue, catalog)
    }
    {
      putInto(ArrayReduceFunctionValue, catalog)
      putInto(StringReduceFunctionValue, catalog)
    }
    {
      putInto(ObjectRemoveFunctionValue, catalog)
      putInto(ArrayRemoveFunctionValue, catalog)
    }
    {
      putInto(BinarySizeOfFunctionValue, catalog)
      putInto(ArraySizeOfFunctionValue, catalog)
      putInto(ObjectSizeOfFunctionValue, catalog)
      putInto(StringSizeOfFunctionValue, catalog)
    }
    {
      putInto(ToRangeFunctionValue, catalog)
    }
    {
      putInto(EmptyStringFunctionValue, catalog)
      putInto(EmptyArrayFunctionValue, catalog)
      putInto(EmptyObjectFunctionValue, catalog)
    }
    {
      putInto(AbsNumberFunctionValue, catalog)
      putInto(CeilNumberFunctionValue, catalog)
      putInto(ModuleNumberFunctionValue, catalog)
      putInto(PowNumberFunctionValue, catalog)
      putInto(CeilNumberFunctionValue, catalog)
      putInto(FloorNumberFunctionValue, catalog)
      putInto(ModuleNumberFunctionValue, catalog)
      putInto(PowNumberFunctionValue, catalog)
      putInto(RoundNumberFunctionValue, catalog)
      putInto(SqrtNumberFunctionValue, catalog)
      putInto(DecimalNumberFunctionValue, catalog)
      putInto(IntegerNumberFunctionValue, catalog)
      putInto(ACosFunctionValue, catalog)
      putInto(ASinFunctionValue, catalog)
      putInto(ATanFunctionValue, catalog)
      putInto(CosFunctionValue, catalog)
      putInto(Log10FunctionValue, catalog)
      putInto(LognFunctionValue, catalog)
      putInto(SinFunctionValue, catalog)
      putInto(TanFunctionValue, catalog)
    }
    {
      putInto(BigDecimalDivisionFunctionValue, catalog)
      putInto(BigDecimalMultiplicationFunctionValue, catalog)
      putInto(BigDecimalAdditionFunctionValue, catalog)
      putInto(BigDecimalSubtractionFunctionValue, catalog)
      putInto(BigDecimalPowerFunctionValue, catalog)
      putInto(BigDecimalSqrtFunctionValue, catalog)
      putInto(BigDecimalRoundFunctionValue, catalog)
    }
    {
      catalog.put("FromMimeTypeString", FromMimeTypeStringFunctionValue)
      catalog.put("ToMimeTypeString", ToMimeTypeStringFunctionValue)
      catalog.put("IsHandledBy", IsHandledByFunctionValue)
      catalog.put("EvaluateCompatibilityFlagFunctionValue", EvaluateCompatibilityFlagFunctionValue)
      catalog.put("version", DataWeaveVersionFunctionValue)
      catalog.put("log", LogFunctionValue)
      catalog.put("fail", FailFunctionValue)
      catalog.put("wait", WaitFunctionValue)
      catalog.put("env", EnvFunctionValue)
      catalog.put("props", SystemPropFunctionValue)
      catalog.put("read", new ReadFunctionValue)
      catalog.put("readUrl", ReadUrlFunctionValue)
      catalog.put("write", WriteFunctionValue)
      catalog.put("try", TryFunctionValue)
      catalog.put("location", LocationFunctionValue)
      catalog.put("now", NowFunctionValue)
      catalog.put("daysBetween", DaysBetweenFunctionValue)
      catalog.put("HMACFunctionValue", HMACFunctionValue)
      catalog.put("HashFunctionValue", HashFunctionValue)
      catalog.put("CharCodeFunctionValue", CharCodeFunctionValue)
      catalog.put("FromCharCodeFunctionValue", FromCharCodeFunctionValue)
      catalog.put("uuid", UUIDFunctionValue)
      catalog.put("random", RandomFunctionValue)
    }

    {
      putInto(LeapLocalDateFunctionValue, catalog)
      putInto(LeapDateTimeFunctionValue, catalog)
      putInto(LeapLocalDateTimeFunctionValue, catalog)
    }
    {
      putInto(TypeOfAnyFunctionValue, catalog)
      putInto(SecurityManagerCheckFunctionValue, catalog)
    }
  }
}
