package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentsNode

object AnnotationArgumentsNodeSerializer extends AstNodeSerializer[AnnotationArgumentsNode] {

  override protected def doSerialize(node: AnnotationArgumentsNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val args = AnnotationArgumentNodeSerializer.serializeSeq(node.args)
    val children = Seq(_annotations, args)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_ARGUMENTS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): AnnotationArgumentsNode = {
    val args = AnnotationArgumentNodeSerializer.deserializeSeq(children.head, context)
    AnnotationArgumentsNode(args)
  }
}
