package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.functions.FunctionParameters

object FunctionParametersSerializer extends AstNodeSerializer[FunctionParameters] {

  override protected def doSerialize(node: FunctionParameters, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val paramList = FunctionParameterSerializer.serializeSeq(node.paramList)
    val children: Seq[SerializableAstNode] = Seq(_annotations, paramList)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_PARAMETERS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): FunctionParameters = {
    val parameters = FunctionParameterSerializer.deserializeSeq(children.head, context)
    FunctionParameters(parameters)
  }
}
