package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.PatternMatcherNode

object PatternMatcherNodeSerializer extends AstNodeSerializer[PatternMatcherNode] {

  override protected def doSerialize(node: PatternMatcherNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val lhs = AstToSerializableMapper.serialize(node.lhs)
    val patterns = PatternExpressionsNodeSerializer.serialize(node.patterns)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, lhs, patterns, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.PATTERN_MATCHER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): PatternMatcherNode = {
    val lhs = AstToSerializableMapper.deserialize(children.head, context)
    val patterns = PatternExpressionsNodeSerializer.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    PatternMatcherNode(lhs, patterns, annotations)
  }
}
