package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode

object VarDirectiveSerializer extends AstNodeSerializer[VarDirective] {

  override protected def doSerialize(node: VarDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val value = AstToSerializableMapper.serialize(node.value)
    val wtype = AstToSerializableMapper.serializeMaybe(node.wtype)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, value, wtype, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.VAR_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): VarDirective = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, context)
    val value = AstToSerializableMapper.deserialize(children(1), context)
    val wtype = AstToSerializableMapper.deserializeMaybe(children(2), context).asInstanceOf[Option[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    VarDirective(identifier, value, wtype, annotations)
  }
}
