package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode

object VariableReferenceNodeSerializer extends AstNodeSerializer[VariableReferenceNode] {

  override protected def doSerialize(node: VariableReferenceNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.VARIABLE_REFERENCE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): VariableReferenceNode = {
    val variable = NameIdentifierSerializer.deserialize(children.head, context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), context)
    VariableReferenceNode(variable, annotations)
  }
}
