package org.mule.weave.v2.interpreted.module

import java.nio.charset.Charset

import org.mule.weave.v2.interpreted.module.reader.WeaveReader
import org.mule.weave.v2.interpreted.module.reader.WeaveReaderSettings
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.service.CharsetProviderService
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.writer.DeferredWriter
import org.mule.weave.v2.module.writer.TargetProvider
import org.mule.weave.v2.parser.module.MimeType
import org.mule.weave.v2.parser.phase.ModuleLoader
import org.mule.weave.v2.parser.phase.ModuleLoaderManager
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver
import org.mule.weave.v2.sdk.SPIBasedModuleLoaderProvider
import org.mule.weave.v2.utils.WeaveFile

class WeaveDataFormat extends DataFormat[WeaveReaderSettings, WeaveWriterSettings] {

  lazy val _moduleLoader: ModuleLoaderManager = createModuleLoader()

  def createModuleLoader(): ModuleLoaderManager = {
    val weaveResourceResolver = ClassLoaderWeaveResourceResolver()
    ModuleLoaderManager(Seq(ModuleLoader(weaveResourceResolver)), SPIBasedModuleLoaderProvider(weaveResourceResolver))
  }

  override def name(): String = "dw"

  override def label(): String = "DataWeave (dw)"

  override def writer(target: Option[Any], outputMimeType: MimeType)(implicit ctx: EvaluationContext): DeferredWriter[WeaveWriterSettings] = {
    DeferredWriter(WeaveWriter.apply, TargetProvider(target), createWriterSettings())
  }

  override def reader(source: SourceProvider)(implicit ctx: EvaluationContext): WeaveReader = {
    WeaveReader(source, _moduleLoader, createReaderSettings())
  }

  override val defaultMimeType: MimeType = new MimeType("application", "dw")

  override val acceptedMimeTypes: Seq[MimeType] = Seq(new MimeType("*", "dw"))

  /**
    * The file extensions associated with this DataFormat. (".json", ".xml", etc...)
    * Note: This can be empty
    */
  override def fileExtensions: Seq[String] = Seq(WeaveDataFormatUtils.DATA_WEAVE_EXTENSION)

  /**
    * Returns the default charset of this given data format
    *
    * @return
    */
  override def defaultCharset: Option[CharsetProviderService#Charset] = {
    Option(Charset.forName("UTF-8"))
  }

  override def readerSettings(): WeaveReaderSettings = new WeaveReaderSettings()

  override def writerSettings(): WeaveWriterSettings = new WeaveWriterSettings()
}

object WeaveDataFormatUtils {
  val DATA_WEAVE_EXTENSION: String = WeaveFile.fileExtension

  val defaultMimeType: MimeType = {
    new MimeType("application", "dw")
  }
}
