package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.{ NodeSerializableAstNode, SerializableAstNode, SerializableAstNodeKind, UnknownLocation }
import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, DWSerializer, SerializerContext }
import org.mule.weave.v2.interpreted.marker.ReferenceValue

object ReferenceValueSerializer extends DWSerializer[ReferenceValue] {

  override def serialize(referenceVal: ReferenceValue): SerializableAstNode = {
    val refChildren = Seq(
      AstToSerializableMapper.serializeMaybe(referenceVal.moduleFQN),
      serializeString(referenceVal.localVariableName),
      NoSourceLocationValueSerializer.serializeMaybe(referenceVal.referenceLocation))
    NodeSerializableAstNode(SerializableAstNodeKind.REFERENCE_VALUE_NODE, UnknownLocation, refChildren)
  }

  override def deserialize(node: SerializableAstNode, context: SerializerContext): ReferenceValue = {
    val moduleFQN = NameIdentifierSerializer.deserializeMaybe(node.children().head, context)
    val localVariableName = AstToSerializableMapper.deserializeString(node.children()(1))
    val location = NoSourceLocationValueSerializer.deserializeMaybe(node.children()(2), context)
    ReferenceValue(moduleFQN, localVariableName, location)
  }
}
