package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.structure.header.HeaderNode
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.ast.WeaveLocationCapable

class DoBlockNode(val header: HeaderNode, val body: ValueNode[_]) extends ValueNode[Any] with Product2[HeaderNode, ValueNode[_]] with WeaveLocationCapable {
  override def _1: HeaderNode = header

  override def _2: ValueNode[_] = body

  override protected def doExecute(implicit ctx: ExecutionContext): Value[_] = {
    ctx.runInNewFrame(this, Some("Do-Block"), {
      header.execute
      body.execute
    })
  }
}