package org.mule.weave.v2.interpreted

import org.mule.weave.v2.interpreted.marker.ConstantArgumentMarker
import org.mule.weave.v2.interpreted.marker.DoBlockNodeMarker
import org.mule.weave.v2.interpreted.marker.FunctionCallNodeMarker
import org.mule.weave.v2.interpreted.marker.LazyVarDirectiveMarker
import org.mule.weave.v2.interpreted.marker.LiteralValueMarker
import org.mule.weave.v2.interpreted.marker.NameSlotMarker
import org.mule.weave.v2.interpreted.marker.NativeFunctionMarker
import org.mule.weave.v2.interpreted.marker.OverloadedFunctionNotCacheableMarker
import org.mule.weave.v2.interpreted.marker.ParameterReferenceFunctionCallArgumentMarker
import org.mule.weave.v2.interpreted.marker.RequiresMaterializationMarker
import org.mule.weave.v2.interpreted.marker.StaticFunctionCallMarker
import org.mule.weave.v2.interpreted.marker.TypeParameterNodeMarker
import org.mule.weave.v2.parser.annotation.PreCompiledTypeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.phase.{ AstNodeResultAware, CompilationPhase, FullCompileOnlyPhase, ParsingContext, PhaseResult, ScopeNavigatorResultAware, SuccessResult }
import org.mule.weave.v2.scope.ScopesNavigator

class InterpreterPreCompilerPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware] extends FullCompileOnlyPhase[R, T] {

  private lazy val markers = Seq(
    new FunctionCallNodeMarker(),
    new LazyVarDirectiveMarker(),
    new StaticFunctionCallMarker(),
    new ParameterReferenceFunctionCallArgumentMarker(),
    new NativeFunctionMarker(),
    new ConstantArgumentMarker(),
    new LiteralValueMarker(),
    new DoBlockNodeMarker(),
    new RequiresMaterializationMarker(),
    new OverloadedFunctionNotCacheableMarker(),
    new NameSlotMarker(),
    new TypeParameterNodeMarker())

  override def run(source: T, context: ParsingContext): Unit = {
    val rootNode = source.astNode
    AstNodeHelper.traverse(rootNode, node => {
      markers.foreach(marker => {
        marker.mark(node, source.scope, context)
      })
      true
    })
  }
}

trait InterpreterPreCompilerMarker {
  def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit
}
