package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.structure.NamespaceNode

object NamespaceNodeSerializer extends AstNodeSerializer[NamespaceNode] {

  override protected def doSerialize(node: NamespaceNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val prefix = NameIdentifierSerializer.serialize(node.prefix)
    val children: Seq[SerializableAstNode] = Seq(_annotations, prefix)
    NodeSerializableAstNode(SerializableAstNodeKind.NAMESPACE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NamespaceNode = {
    val prefix = NameIdentifierSerializer.deserialize(children.head, context)
    NamespaceNode(prefix)
  }
}
