package org.mule.weave.v2.interpreted.node.structure.function

import org.mule.weave.v2.interpreted.node.structure.LiteralValueNode
import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.ast.WeaveLocationCapable
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation

class LiteralFunctionValueNode(val value: FunctionValue) extends LiteralValueNode[(Array[Value[_]]) => Value[_]] with WeaveLocationCapable {
  override def location(): WeaveLocation = {
    value.location() match {
      case wl: WeaveLocation => wl
      case _                 => UnknownLocation
    }
  }

  override def shouldNotify: Boolean = false
}
