package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.structure.function.DynamicFunctionNode
import org.mule.weave.v2.interpreted.node.structure.function.FunctionParameterNode
import org.mule.weave.v2.interpreted.node.updater.AttributeKind
import org.mule.weave.v2.interpreted.node.updater.DynamicUpdaterValueNode
import org.mule.weave.v2.interpreted.node.updater.FieldKind
import org.mule.weave.v2.interpreted.node.updater.IndexKind
import org.mule.weave.v2.interpreted.node.updater.MultiFieldKind
import org.mule.weave.v2.interpreted.node.updater.StaticUpdaterValueNode
import org.mule.weave.v2.interpreted.node.updater.UpdaterCaseNode
import org.mule.weave.v2.interpreted.node.updater.UpdaterCasesNode
import org.mule.weave.v2.interpreted.node.updater.UpdaterExpressionElementNode
import org.mule.weave.v2.interpreted.node.updater.UpdaterKind
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.structure.NameNode
import org.mule.weave.v2.parser.ast.structure.NumberNode
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.updates.ArrayIndexUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.AttributeNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.FieldNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.MultiFieldNameUpdateSelectorNode
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionNode
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionsNode
import org.mule.weave.v2.parser.ast.updates.UpdateNode
import org.mule.weave.v2.parser.ast.updates.UpdateSelectorNode

trait EngineUpdaterTransformations extends AstTransformation {

  def transformUpdate(updateNode: UpdateNode): ValueNode[_] = {
    val matchers: UpdateExpressionsNode = updateNode.matchers
    val expressionNode: ValueNode[Any] = transform(updateNode.expression)

    val nodes = AstNodeHelper.collectChildrenWith(updateNode.matchers, classOf[UpdateSelectorNode])
    val dynamic = nodes.exists((ns) => {
      ns.selector match {
        case NameNode(StringNode(_, _), _, _) => false
        case NumberNode(_, _)                 => false
        case _                                => true
      }
    })

    if (dynamic) {
      new DynamicUpdaterValueNode(expressionNode, transform(matchers))
    } else {
      new StaticUpdaterValueNode(expressionNode, transform(matchers))
    }
  }

  def transformUpdateExpressionsNode(expressionsNode: UpdateExpressionsNode): UpdaterCasesNode = {
    val expressions: Seq[UpdateExpressionNode] = expressionsNode.expressions
    new UpdaterCasesNode(transformSeq(expressions))
  }

  def transformUpdateExpressionNode(uen: UpdateExpressionNode): UpdaterCaseNode = {
    val name = uen.name
    val index = FunctionParameterNode(transform(uen.indexId), materialize = false)
    val caseVariableName = FunctionParameterNode(transform(name), needsMaterialization(name))
    val functionBody: ValueNode[Any] = transform(uen.updateExpression)
    val onMatchFunctionNode: DynamicFunctionNode =
      new DynamicFunctionNode(Array(caseVariableName, index), functionBody, returnTypeNode = None, requiresMaterializedArguments = false, literalParameters = true)

    val mayBeConditionFunctionNode = uen.condition.map((conditionBody) => {
      val value: ValueNode[_] = transform(conditionBody)
      new DynamicFunctionNode(Array(caseVariableName, index), value, returnTypeNode = None, requiresMaterializedArguments = false, literalParameters = true)
    })

    val selector: UpdateSelectorNode = uen.selector.asInstanceOf[UpdateSelectorNode]
    UpdaterCaseNode(transform(selector), onMatchFunctionNode, mayBeConditionFunctionNode, uen.forceCreate)
  }

  def transformUpdateSelectorNode(usn: UpdateSelectorNode): UpdaterExpressionElementNode = {

    val kind: UpdaterKind = usn match {
      case _: FieldNameUpdateSelectorNode      => FieldKind
      case _: MultiFieldNameUpdateSelectorNode => MultiFieldKind
      case _: AttributeNameUpdateSelectorNode  => AttributeKind
      case _: ArrayIndexUpdateSelectorNode     => IndexKind
    }

    UpdaterExpressionElementNode(transform(usn.selector), kind, transformOption(usn.child))
  }

}
