package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode

object HeaderNodeSerializer extends AstNodeSerializer[HeaderNode] {

  override protected def doSerialize(node: HeaderNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val directives = AstToSerializableMapper.serializeSeq(node.directives)
    val children: Seq[SerializableAstNode] = Seq(_annotations, directives)
    NodeSerializableAstNode(SerializableAstNodeKind.HEADER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): HeaderNode = {
    val directives = AstToSerializableMapper.deserializeSeq(children.head, context).asInstanceOf[Seq[DirectiveNode]]
    HeaderNode(directives)
  }
}
