package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.types.TypeParametersListNode

object TypeParametersListNodeSerializer extends AstNodeSerializer[TypeParametersListNode] {

  override protected def doSerialize(node: TypeParametersListNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val typeParameters = TypeParameterNodeSerializer.serializeSeq(node.typeParameters)
    val children: Seq[SerializableAstNode] = Seq(_annotations, typeParameters)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_PARAMETERS_LIST_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): TypeParametersListNode = {
    val typeParameters = TypeParameterNodeSerializer.deserializeSeq(children.head, context)
    TypeParametersListNode(typeParameters)
  }
}
