package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionNode

object UpdateExpressionNodeSerializer extends AstNodeSerializer[UpdateExpressionNode] {

  override protected def doSerialize(node: UpdateExpressionNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val indexId = NameIdentifierSerializer.serialize(node.indexId)
    val selector = AstToSerializableMapper.serialize(node.selector)
    val forceCreate = serializeBoolean(node.forceCreate)
    val condition = AstToSerializableMapper.serializeMaybe(node.condition)
    val updateExpression = AstToSerializableMapper.serialize(node.updateExpression)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, indexId, selector, forceCreate, condition, updateExpression)
    NodeSerializableAstNode(SerializableAstNodeKind.UPDATE_EXPRESSION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UpdateExpressionNode = {
    val name = NameIdentifierSerializer.deserialize(children.head, context)
    val indexId = NameIdentifierSerializer.deserialize(children(1), context)
    val selector = AstToSerializableMapper.deserialize(children(2), context)
    val forceCreate = deserializeBoolean(children(3))
    val condition = AstToSerializableMapper.deserializeMaybe(children(4), context)
    val updateExpression = AstToSerializableMapper.deserialize(children(5), context)
    UpdateExpressionNode(name, indexId, selector, forceCreate, condition, updateExpression)
  }
}
