package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.core.exception.InternalExecutionException
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.executors.FunctionExecutor
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.Value

class ChainedFunctionCallNode(val functions: Array[_ <: FunctionExecutor], val args: Array[ValueNode[_]]) extends ValueNode[Any] {

  /**
    * This is a collection of nodes that used to fake the notifications
    */
  private lazy val fakeNodes = functions.map((f) => {
    val node = new DefaultFunctionCallNode(f, Array.empty)
    node._location = Some(f.location())
    node
  })

  override def productElement(n: Int): Any = {
    if (n < args.length) {
      args.apply(n)
    } else {
      functions(n - args.length)
    }
  }

  override def productArity: Int = {
    args.length + functions.length
  }

  override def shouldNotify: Boolean = false

  override protected def doExecute(implicit ctx: ExecutionContext): Value[Any] = {
    var i = 0
    if (ctx.notificationManager().nonEmpty) {
      try {
        var leftValue: Value[_] = NullValue
        var rightValue: Value[_] = NullValue
        val argsArr = new Array[Value[_]](2)
        while (i < args.length) {
          if (i == 0) {
            leftValue = args(0).execute
          } else {
            ctx.notificationManager().preValueNodeExecution(fakeNodes(i - 1))
            rightValue = args(i).execute
            argsArr(0) = leftValue
            argsArr(1) = rightValue
            if (ctx.materializeValues()) {
              leftValue = functions(i - 1).execute(argsArr).materialize
            } else {
              leftValue = functions(i - 1).execute(argsArr)
            }
            ctx.notificationManager().postValueNodeExecution(fakeNodes(i - 1), leftValue)
          }
          i = i + 1
        }
        leftValue
      } catch {
        case iee: InternalExecutionException => {
          throw iee
        }
        case ex: ExecutionException => {
          if (i > 0) {
            ctx.notificationManager().postValueNodeExecution(fakeNodes(i - 1), ex)
          }
          val stacktraceFunctions = functions.slice(0, i + 1)
          for (function <- stacktraceFunctions) {
            ex.addCallToStacktrace(function.location(), function.name())
          }
          throw ex
        }
      }
    } else {
      try {
        var leftValue: Value[_] = NullValue
        var rightValue: Value[_] = NullValue
        val argsArr = new Array[Value[_]](2)
        while (i < args.length) {
          if (i == 0) {
            leftValue = args(0).execute
          } else {
            rightValue = args(i).execute
            argsArr(0) = leftValue
            argsArr(1) = rightValue
            leftValue = functions(i - 1).execute(argsArr)
          }
          i = i + 1
        }
        leftValue
      } catch {
        case ex: ExecutionException =>
          val stacktraceFunctions = functions.slice(0, i + 1)
          for (function <- stacktraceFunctions) {
            ex.addCallToStacktrace(function.location(), function.name())
          }
          throw ex
      }
    }
  }
}
