package org.mule.weave.v2.interpreted.node

class NameSlot(val name: String, val slot: Int, val module: Option[NameSlot] = None) extends ExecutionNode {

  override def equals(other: Any): Boolean = other match {
    case that: NameSlot => name == that.name
    case _              => false
  }

  override def hashCode(): Int = {
    val state = Seq(name)
    state.map(_.hashCode()).foldLeft(0)((a, b) => 31 * a + b)
  }

  def fqn(module: NameSlot): NameSlot = {
    new NameSlot(name, slot, Some(module))
  }

}

object NameSlot {
  def apply(name: String, slot: Int) = new NameSlot(name, slot)
}