package org.mule.weave.v2.interpreted.node.structure.header.directives

class InputDirective(val variableName: String, val mime: Option[ContentType], val options: Option[Seq[DirectiveOption]], val id: Option[String]) extends Directive with Configurable {
  override def productElement(n: Int): Any = {
    n match {
      case 0 => variableName
      case 1 => mime.orNull
      case 2 => options.orNull
      case 3 => id.orNull
    }
  }

  private def toIncrease(field: Option[_]): Int = {
    if (field.isDefined) 1 else 0
  }

  override def productArity: Int = {
    var arity = 1
    arity += toIncrease(options)
    arity += toIncrease(mime)
    arity += toIncrease(id)
    arity
  }
}
