package org.mule.weave.v2.runtime.core.functions.stringops

import java.util.regex.Matcher

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.types.RegexType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation

import scala.collection.mutable.ArrayBuffer

class StringRegexMatchFunctionValue(override val location: WeaveLocation) extends BinaryFunctionValue {

  override val L = StringType

  override val R = RegexType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[ArraySeq] = {
    val resultBuilder = new ArrayBuffer[Value[_]]
    val pattern = rightValue.evaluate.pattern
    val matcher: Matcher = ctx.serviceManager.patternService.matcher(pattern, leftValue.evaluate, this)
    if (matcher.matches()) {
      val count: Int = matcher.groupCount()
      var index = 0
      while (index <= count) {
        val group: String = matcher.group(index)
        resultBuilder.+=(if (group == null) NullValue else StringValue(group, this))
        index = index + 1
      }
    }
    ArrayValue(ArraySeq(resultBuilder.result()), this)
  }
}

object StringRegexMatchFunctionValue extends StringRegexMatchFunctionValue(UnknownLocation)

object MatchFunctionValue {
  val value = Seq(StringRegexMatchFunctionValue)
}

