package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.structure.RegexNode

object RegexNodeSerializer extends AstNodeSerializer[RegexNode] {

  override protected def doSerialize(node: RegexNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val value = serializeString(node.literalValue)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, value, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.REGEX_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): RegexNode = {
    val value = deserializeString(children.head)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), context)
    RegexNode(value, annotations)
  }
}
