package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.header.directives.DirectiveOption

object DirectiveOptionSerializer extends AstNodeSerializer[DirectiveOption] {

  override protected def doSerialize(node: DirectiveOption, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = DirectiveOptionNameSerializer.serialize(node.name)
    val value = AstToSerializableMapper.serialize(node.value)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, value)
    NodeSerializableAstNode(SerializableAstNodeKind.DIRECTIVE_OPTION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DirectiveOption = {
    val name = DirectiveOptionNameSerializer.deserialize(children.head, context)
    val value = AstToSerializableMapper.deserialize(children(1), context)
    DirectiveOption(name, value)
  }
}
