package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode

object FunctionDirectiveNodeSerializer extends AstNodeSerializer[FunctionDirectiveNode] {

  override protected def doSerialize(node: FunctionDirectiveNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val literal = AstToSerializableMapper.serialize(node.literal)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, literal, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): FunctionDirectiveNode = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, context)
    val literal = AstToSerializableMapper.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    FunctionDirectiveNode(identifier, literal, annotations)
  }
}
