package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.structure.schema.SchemaNode

object SchemaNodeSerializer extends AstNodeSerializer[SchemaNode] {

  override protected def doSerialize(node: SchemaNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val properties = SchemaPropertyNodeSerializer.serializeSeq(node.properties)
    val children: Seq[SerializableAstNode] = Seq(_annotations, properties)
    NodeSerializableAstNode(SerializableAstNodeKind.SCHEMA_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): SchemaNode = {
    val properties = SchemaPropertyNodeSerializer.deserializeSeq(children.head, context)
    SchemaNode(properties)
  }
}
