package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.nonAst.OpIdSerializer
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.grammar.UnaryOpIdentifier
import org.mule.weave.v2.parser.ast.operators.UnaryOpNode

object UnaryOpNodeSerializer extends AstNodeSerializer[UnaryOpNode] {

  override protected def doSerialize(node: UnaryOpNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val opId = OpIdSerializer.serialize(node.opId)
    val rhs = AstToSerializableMapper.serialize(node.rhs)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, opId, rhs, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.UNARY_OP_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UnaryOpNode = {
    val op = OpIdSerializer.deserialize(children.head, context).asInstanceOf[UnaryOpIdentifier]
    val rhs = AstToSerializableMapper.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    UnaryOpNode(op, rhs, annotations)
  }
}
