package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.{ NodeSerializableAstNode, SerializableAstNode, SerializableAstNodeKind, UnknownLocation }
import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.compilation.mapper.{ DWSerializer, SerializerContext }
import org.mule.weave.v2.interpreted.marker.InterceptorNativeFunctionValue

object InterceptorNativeFunctionValueSerializer extends DWSerializer[InterceptorNativeFunctionValue] {

  override def serialize(nativeFunctionValue: InterceptorNativeFunctionValue): SerializableAstNode = {
    val children = Seq(
      NameIdentifierSerializer.serialize(nativeFunctionValue.functionName),
      NoSourceLocationValueSerializer.serializeMaybe(nativeFunctionValue.location))
    NodeSerializableAstNode(SerializableAstNodeKind.INTERCEPTOR_NATIVE_FUNCTION_VALUE_NODE, UnknownLocation, children)
  }

  override def deserialize(node: SerializableAstNode, context: SerializerContext): InterceptorNativeFunctionValue = {
    val functionName = NameIdentifierSerializer.deserialize(node.children().head, context)
    val location = NoSourceLocationValueSerializer.deserializeMaybe(node.children()(1), context)
    InterceptorNativeFunctionValue(functionName, location)
  }
}
