package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.mapper.ast.NameIdentifierSerializer
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, DWSerializer, SerializerContext }
import org.mule.weave.v2.compilation.{ NodeSerializableAstNode, SerializableAstNode, SerializableAstNodeKind, UnknownLocation }
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.{ NoSourceLocation, NoSourcePosition, UnknownLocation => ParserUnkownLocation }

object NoSourceLocationValueSerializer extends DWSerializer[NoSourceLocation] {
  private def isUnknownLocation(node: SerializableAstNode, context: SerializerContext): Boolean = {
    val start = deserializeInt(node.children().head)
    val end = deserializeInt(node.children()(3))
    val nameIdentifier = NameIdentifierSerializer.deserialize(node.children()(6), context)

    start == 0 && end == 0 && nameIdentifier == NameIdentifier.ANONYMOUS_NAME
  }

  override def serialize(value: NoSourceLocation): SerializableAstNode = {
    val children = Seq(
      serializeInt(value.startPosition.index),
      serializeInt(value.startPosition.line),
      serializeInt(value.startPosition.column),

      serializeInt(value.endPosition.index),
      serializeInt(value.endPosition.line),
      serializeInt(value.endPosition.column),

      AstToSerializableMapper.serialize(value.resourceName))
    NodeSerializableAstNode(SerializableAstNodeKind.LOCATION_VALUE_NODE, UnknownLocation, children)
  }

  override def deserialize(node: SerializableAstNode, context: SerializerContext): NoSourceLocation = {
    if (isUnknownLocation(node, context)) {
      NoSourceLocation.fromLocation(ParserUnkownLocation)
    } else {
      val nameIdentifier = NameIdentifierSerializer.deserialize(node.children()(6), context)

      val sIndex = deserializeInt(node.children().head)
      val sLine = deserializeInt(node.children()(1))
      val sCol = deserializeInt(node.children()(2))

      val startPosition = NoSourcePosition(sIndex, sLine, sCol)

      val eIndex = deserializeInt(node.children()(3))
      val eLine = deserializeInt(node.children()(4))
      val eCol = deserializeInt(node.children()(5))

      val endPosition = NoSourcePosition(eIndex, eLine, eCol)

      new NoSourceLocation(startPosition, endPosition, nameIdentifier)
    }
  }
}
