package org.mule.weave.v2.interpreted.listener

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.runtime.ExecutableWeave

class WatchdogExecutionListener(maxTime: Long) extends WeaveExecutionListener {

  override def onExecutionStarted(executableWeave: ExecutableWeave[_ <: AstNode])(implicit ctx: EvaluationContext): Unit = {
    ctx.serviceManager.cpuLimitService.executionStarted(executableWeave.astDocument(), maxTime)
  }

  override def preExecution(node: ValueNode[_])(implicit ctx: ExecutionContext): Unit = {
    ctx.serviceManager.cpuLimitService.check(node.location())
  }

  override def postExecution(node: ValueNode[_], result: Value[_])(implicit ctx: ExecutionContext): Unit = {
    ctx.serviceManager.cpuLimitService.check(node.location())
  }

  override def postExecution(node: ValueNode[_], e: Exception)(implicit ctx: ExecutionContext): Unit = {
    //    ctx.serviceManager.cpuLimitService.check(node.location())
  }

  override def onExecutionEnded(executableWeave: ExecutableWeave[_ <: AstNode])(implicit ctx: EvaluationContext): Unit = {
    ctx.serviceManager.cpuLimitService.executionEnded(executableWeave.astDocument())
  }

}
