package org.mule.weave.v2.interpreted.node.structure.header.directives

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.structure.function.DefaultExecutionContextAwareFunction
import org.mule.weave.v2.interpreted.node.structure.function.ExecutionContextAwareFunctionValue
import org.mule.weave.v2.interpreted.node.structure.function.FunctionParameterNode
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.model.values.SchemaProvider
import org.mule.weave.v2.model.values.TypeSchemaResolver
import org.mule.weave.v2.model.values.TypeValue
import org.mule.weave.v2.model.values.Value

class TypeDirective(variable: NameSlot, t: ValueNode[Type]) extends Directive with Product2[NameSlot, ValueNode[_]] {
  override def execute(implicit ctx: ExecutionContext): Unit = {
    val typeName: String = variable.name
    val extendType: Value[Type] = t.execute
    val schemaProvider = SchemaProvider(new TypeDirectiveSchemaResolver(extendType))
    ctx.executionStack().setVariable(variable.slot, TypeValue(Type.extend(typeName, extendType.evaluate, () => None), this, Some(schemaProvider)))
  }

  override def _1: NameSlot = variable

  override def _2: ValueNode[_] = t
}

class TypeFunctionDirective(variable: NameSlot, body: ValueNode[Type], parameters: Array[FunctionParameterNode]) extends Directive with Product3[NameSlot, ValueNode[Type], Seq[FunctionParameterNode]] {

  override def execute(implicit ctx: ExecutionContext): Unit = {
    val typeName: String = variable.name
    val paramValues = ExecutionContextAwareFunctionValue.calculateParams(parameters, ctx)
    val typeFactoryFunction = DefaultExecutionContextAwareFunction(paramValues, parameters, body, None, Some(typeName), ctx.executionStack().activeFrame(), this, parameters.length, parameters.length, false)
    ctx
      .executionStack()
      .setVariable(
        variable.slot,
        typeFactoryFunction)
  }

  override def _1: NameSlot = variable

  override def _2: ValueNode[Type] = body

  override def _3: Seq[FunctionParameterNode] = parameters
}

class TypeDirectiveSchemaResolver(extendType: Value[Type]) extends TypeSchemaResolver {

  override def resolve(ctx: EvaluationContext): Option[Schema] = {
    extendType.schema(ctx)
  }
}