package org.mule.weave.v2.lang

import java.util
import java.util.{ List => JList }
import java.util.{ Map => JMap }

import org.mule.weave.v2.annotations.WeaveApi
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.DataFormatManager
import org.mule.weave.v2.module.option.ModuleOption

import scala.collection.JavaConverters._
import scala.collection.mutable

@WeaveApi(Seq("Studio"))
object ModuleOptionsAPI {

  def readerOptions(contentType: String): JList[JMap[String, String]] = options(_.readerOptions(), contentType)

  def writerOptions(contentType: String): JList[JMap[String, String]] = options(_.writerOptions(), contentType)

  private def options(opts: DataFormat[_, _] => Map[String, ModuleOption], contentType: String): JList[JMap[String, String]] = {
    implicit val ctx = EvaluationContext()
    DataFormatManager.byContentType(contentType) match {
      case Some(module) => {
        opts(module).values.toList.map(optionToMap).asJava
      }
      case None => new util.ArrayList()
    }
  }

  def optionToMap(option: ModuleOption): JMap[String, String] = {
    val defaultMap: mutable.HashMap[String, String] = mutable.HashMap(
      "name" -> option.name,
      "type" -> option.dataType.toString,
      "defaultValue" -> toStr(option.defaultValue),
      "description" -> option.description,
      "possibleValues" -> option.possibleValues.mkString(","))

    defaultMap.asJava
  }

  private def toStr(any: Any): String = {
    any match {
      case Some(value) => value.toString
      case None        => ""
      case null        => ""
      case _           => any.toString
    }
  }
}
